Imports System.IO

Public Class Form1
    Inherits System.Windows.Forms.Form

    Private UPV As New UPx.Application      'Include UPV driver
    Private Structure CalibrationData
        Dim Usage As Byte
        Dim CalValue As Double
        Dim TargetLevel As Double
        Dim CalLowerFrequency As Double
        Dim CalUpperFrequency As Double
        Dim EqualizationFileName As String
    End Structure
    Private _CalibrationDevice(2) As CalibrationData
    Private Limit(2) As Double
    Private ValueName() As String = {"L(A)eq", "L(A)eq", "Vm", "Vm", "WBCV"}
    Private Unit() As String = {"dBSPL(A)", "dBSPL(A)", "mV", "mV", "mV"}
    Dim Description() As String = {"Player + Headset, EN 50332-1", "FM Tuner + Headset, EM 50332-1", "Player only, EN 50332-2", "FM Tuner only, EN 50332-2", "Headphones only, EN 50332-2"}
    Private WithEvents RPT As New UPVReport
    Private Binaural As Boolean
    Private MeasType As Byte
    Private ResultValue(1) As Double
    Private PreviousIndex As Integer = -1
    'Version = 1.0.2

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents GroupBox7 As System.Windows.Forms.GroupBox
    Friend WithEvents Button5 As System.Windows.Forms.Button
    Friend WithEvents Button6 As System.Windows.Forms.Button
    Friend WithEvents Label7 As System.Windows.Forms.Label
    Friend WithEvents TextBox3 As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox6 As System.Windows.Forms.GroupBox
    Friend WithEvents Button3 As System.Windows.Forms.Button
    Friend WithEvents Button2 As System.Windows.Forms.Button
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents TextBox2 As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents CheckBox1 As System.Windows.Forms.CheckBox
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents NumericUpDown1 As System.Windows.Forms.NumericUpDown
    Friend WithEvents ComboBox1 As System.Windows.Forms.ComboBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBox4 As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
    Friend WithEvents Button12 As System.Windows.Forms.Button
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents TextBox5 As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox4 As System.Windows.Forms.GroupBox
    Friend WithEvents TextBox6 As System.Windows.Forms.TextBox
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents TextBox7 As System.Windows.Forms.TextBox
    Friend WithEvents Label8 As System.Windows.Forms.Label
    Friend WithEvents TextBox8 As System.Windows.Forms.TextBox
    Friend WithEvents Label9 As System.Windows.Forms.Label
    Friend WithEvents TextBox9 As System.Windows.Forms.TextBox
    Friend WithEvents Label10 As System.Windows.Forms.Label
    Friend WithEvents CheckBox3 As System.Windows.Forms.CheckBox
    Friend WithEvents Button13 As System.Windows.Forms.Button
    Friend WithEvents Button14 As System.Windows.Forms.Button
    Friend WithEvents Button15 As System.Windows.Forms.Button
    Friend WithEvents Button16 As System.Windows.Forms.Button
    Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
    Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
    Friend WithEvents TextBox10 As System.Windows.Forms.TextBox
    Friend WithEvents Label11 As System.Windows.Forms.Label
    Friend WithEvents GroupBox5 As System.Windows.Forms.GroupBox
    Friend WithEvents CheckBox5 As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBox4 As System.Windows.Forms.CheckBox
    Friend WithEvents NumericUpDown2 As System.Windows.Forms.NumericUpDown
    Friend WithEvents Label12 As System.Windows.Forms.Label
    Friend WithEvents ComboBox2 As System.Windows.Forms.ComboBox
    Friend WithEvents Button7 As System.Windows.Forms.Button
    Friend WithEvents Label13 As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
        Me.GroupBox7 = New System.Windows.Forms.GroupBox
        Me.Button5 = New System.Windows.Forms.Button
        Me.Button6 = New System.Windows.Forms.Button
        Me.Label7 = New System.Windows.Forms.Label
        Me.TextBox3 = New System.Windows.Forms.TextBox
        Me.GroupBox6 = New System.Windows.Forms.GroupBox
        Me.Button3 = New System.Windows.Forms.Button
        Me.Button2 = New System.Windows.Forms.Button
        Me.Label4 = New System.Windows.Forms.Label
        Me.TextBox2 = New System.Windows.Forms.TextBox
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.Button7 = New System.Windows.Forms.Button
        Me.ComboBox2 = New System.Windows.Forms.ComboBox
        Me.Button16 = New System.Windows.Forms.Button
        Me.CheckBox1 = New System.Windows.Forms.CheckBox
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        Me.Label13 = New System.Windows.Forms.Label
        Me.TextBox4 = New System.Windows.Forms.TextBox
        Me.TextBox1 = New System.Windows.Forms.TextBox
        Me.Label3 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.ComboBox1 = New System.Windows.Forms.ComboBox
        Me.NumericUpDown1 = New System.Windows.Forms.NumericUpDown
        Me.Label1 = New System.Windows.Forms.Label
        Me.GroupBox3 = New System.Windows.Forms.GroupBox
        Me.TextBox10 = New System.Windows.Forms.TextBox
        Me.Label11 = New System.Windows.Forms.Label
        Me.Button15 = New System.Windows.Forms.Button
        Me.Button14 = New System.Windows.Forms.Button
        Me.Button13 = New System.Windows.Forms.Button
        Me.CheckBox3 = New System.Windows.Forms.CheckBox
        Me.GroupBox4 = New System.Windows.Forms.GroupBox
        Me.TextBox9 = New System.Windows.Forms.TextBox
        Me.Label10 = New System.Windows.Forms.Label
        Me.TextBox8 = New System.Windows.Forms.TextBox
        Me.Label9 = New System.Windows.Forms.Label
        Me.TextBox7 = New System.Windows.Forms.TextBox
        Me.Label8 = New System.Windows.Forms.Label
        Me.TextBox6 = New System.Windows.Forms.TextBox
        Me.Label6 = New System.Windows.Forms.Label
        Me.TextBox5 = New System.Windows.Forms.TextBox
        Me.Label5 = New System.Windows.Forms.Label
        Me.Button12 = New System.Windows.Forms.Button
        Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
        Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog
        Me.GroupBox5 = New System.Windows.Forms.GroupBox
        Me.Label12 = New System.Windows.Forms.Label
        Me.NumericUpDown2 = New System.Windows.Forms.NumericUpDown
        Me.CheckBox4 = New System.Windows.Forms.CheckBox
        Me.CheckBox5 = New System.Windows.Forms.CheckBox
        Me.GroupBox7.SuspendLayout()
        Me.GroupBox6.SuspendLayout()
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        CType(Me.NumericUpDown1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox3.SuspendLayout()
        Me.GroupBox4.SuspendLayout()
        Me.GroupBox5.SuspendLayout()
        CType(Me.NumericUpDown2, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'GroupBox7
        '
        Me.GroupBox7.Controls.Add(Me.Button5)
        Me.GroupBox7.Controls.Add(Me.Button6)
        Me.GroupBox7.Controls.Add(Me.Label7)
        Me.GroupBox7.Controls.Add(Me.TextBox3)
        Me.GroupBox7.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox7.Location = New System.Drawing.Point(8, 216)
        Me.GroupBox7.Name = "GroupBox7"
        Me.GroupBox7.Size = New System.Drawing.Size(320, 136)
        Me.GroupBox7.TabIndex = 26
        Me.GroupBox7.TabStop = False
        Me.GroupBox7.Text = "Channel 2 (Left Ear)"
        '
        'Button5
        '
        Me.Button5.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Button5.Location = New System.Drawing.Point(168, 24)
        Me.Button5.Name = "Button5"
        Me.Button5.Size = New System.Drawing.Size(144, 23)
        Me.Button5.TabIndex = 27
        Me.Button5.Text = "Mic Calibration"
        '
        'Button6
        '
        Me.Button6.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Button6.Location = New System.Drawing.Point(168, 56)
        Me.Button6.Name = "Button6"
        Me.Button6.Size = New System.Drawing.Size(144, 23)
        Me.Button6.TabIndex = 26
        Me.Button6.Text = "Open File"
        '
        'Label7
        '
        Me.Label7.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Label7.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label7.Location = New System.Drawing.Point(8, 56)
        Me.Label7.Name = "Label7"
        Me.Label7.Size = New System.Drawing.Size(144, 23)
        Me.Label7.TabIndex = 24
        Me.Label7.Text = "Calibration File"
        '
        'TextBox3
        '
        Me.TextBox3.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox3.Location = New System.Drawing.Point(8, 96)
        Me.TextBox3.Name = "TextBox3"
        Me.TextBox3.Size = New System.Drawing.Size(304, 23)
        Me.TextBox3.TabIndex = 23
        Me.TextBox3.Text = "select ..."
        '
        'GroupBox6
        '
        Me.GroupBox6.Controls.Add(Me.Button3)
        Me.GroupBox6.Controls.Add(Me.Button2)
        Me.GroupBox6.Controls.Add(Me.Label4)
        Me.GroupBox6.Controls.Add(Me.TextBox2)
        Me.GroupBox6.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox6.Location = New System.Drawing.Point(8, 64)
        Me.GroupBox6.Name = "GroupBox6"
        Me.GroupBox6.Size = New System.Drawing.Size(320, 136)
        Me.GroupBox6.TabIndex = 25
        Me.GroupBox6.TabStop = False
        Me.GroupBox6.Text = "Channel 1 (Right Ear)"
        '
        'Button3
        '
        Me.Button3.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Button3.Location = New System.Drawing.Point(168, 24)
        Me.Button3.Name = "Button3"
        Me.Button3.Size = New System.Drawing.Size(144, 23)
        Me.Button3.TabIndex = 26
        Me.Button3.Text = "Mic Calibration"
        '
        'Button2
        '
        Me.Button2.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Button2.Location = New System.Drawing.Point(168, 56)
        Me.Button2.Name = "Button2"
        Me.Button2.Size = New System.Drawing.Size(144, 23)
        Me.Button2.TabIndex = 25
        Me.Button2.Text = "Open File"
        '
        'Label4
        '
        Me.Label4.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Label4.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label4.Location = New System.Drawing.Point(8, 56)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(144, 23)
        Me.Label4.TabIndex = 23
        Me.Label4.Text = "Calibration File"
        '
        'TextBox2
        '
        Me.TextBox2.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox2.Location = New System.Drawing.Point(8, 96)
        Me.TextBox2.Name = "TextBox2"
        Me.TextBox2.Size = New System.Drawing.Size(304, 23)
        Me.TextBox2.TabIndex = 22
        Me.TextBox2.Text = "select ..."
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.Button7)
        Me.GroupBox1.Controls.Add(Me.ComboBox2)
        Me.GroupBox1.Controls.Add(Me.Button16)
        Me.GroupBox1.Controls.Add(Me.CheckBox1)
        Me.GroupBox1.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox1.Location = New System.Drawing.Point(8, 384)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(336, 104)
        Me.GroupBox1.TabIndex = 27
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Measurement"
        '
        'Button7
        '
        Me.Button7.Enabled = False
        Me.Button7.Location = New System.Drawing.Point(248, 64)
        Me.Button7.Name = "Button7"
        Me.Button7.Size = New System.Drawing.Size(72, 23)
        Me.Button7.TabIndex = 41
        Me.Button7.Text = "Start"
        '
        'ComboBox2
        '
        Me.ComboBox2.Items.AddRange(New Object() {"Player + Headset, EN 50332-1", "FM Tuner + Headset, EN 50332-1", "Player only, EN 50332-2", "FM Tuner only, EN 50332-2", "Headphones only, EN 50332-2"})
        Me.ComboBox2.Location = New System.Drawing.Point(16, 24)
        Me.ComboBox2.Name = "ComboBox2"
        Me.ComboBox2.Size = New System.Drawing.Size(224, 24)
        Me.ComboBox2.TabIndex = 40
        Me.ComboBox2.Text = "Select ..."
        '
        'Button16
        '
        Me.Button16.Location = New System.Drawing.Point(248, 24)
        Me.Button16.Name = "Button16"
        Me.Button16.Size = New System.Drawing.Size(72, 23)
        Me.Button16.TabIndex = 33
        Me.Button16.Text = "Setup ?"
        '
        'CheckBox1
        '
        Me.CheckBox1.Enabled = False
        Me.CheckBox1.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBox1.Location = New System.Drawing.Point(40, 64)
        Me.CheckBox1.Name = "CheckBox1"
        Me.CheckBox1.Size = New System.Drawing.Size(80, 24)
        Me.CheckBox1.TabIndex = 29
        Me.CheckBox1.Text = "Binaural"
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.Label13)
        Me.GroupBox2.Controls.Add(Me.TextBox4)
        Me.GroupBox2.Controls.Add(Me.TextBox1)
        Me.GroupBox2.Controls.Add(Me.Label3)
        Me.GroupBox2.Controls.Add(Me.Label2)
        Me.GroupBox2.Controls.Add(Me.ComboBox1)
        Me.GroupBox2.Controls.Add(Me.NumericUpDown1)
        Me.GroupBox2.Controls.Add(Me.Label1)
        Me.GroupBox2.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox2.Location = New System.Drawing.Point(352, 8)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(312, 160)
        Me.GroupBox2.TabIndex = 28
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Results"
        '
        'Label13
        '
        Me.Label13.Location = New System.Drawing.Point(80, 48)
        Me.Label13.Name = "Label13"
        Me.Label13.Size = New System.Drawing.Size(216, 23)
        Me.Label13.TabIndex = 7
        Me.Label13.Text = "Measurement Result"
        '
        'TextBox4
        '
        Me.TextBox4.BackColor = System.Drawing.SystemColors.ControlDarkDark
        Me.TextBox4.Font = New System.Drawing.Font("Tahoma", 18.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox4.ForeColor = System.Drawing.SystemColors.ControlLightLight
        Me.TextBox4.Location = New System.Drawing.Point(80, 120)
        Me.TextBox4.Name = "TextBox4"
        Me.TextBox4.ReadOnly = True
        Me.TextBox4.Size = New System.Drawing.Size(216, 36)
        Me.TextBox4.TabIndex = 6
        Me.TextBox4.Text = "---"
        Me.TextBox4.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'TextBox1
        '
        Me.TextBox1.BackColor = System.Drawing.SystemColors.ControlDarkDark
        Me.TextBox1.Font = New System.Drawing.Font("Tahoma", 18.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox1.ForeColor = System.Drawing.SystemColors.ControlLightLight
        Me.TextBox1.Location = New System.Drawing.Point(80, 72)
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.ReadOnly = True
        Me.TextBox1.Size = New System.Drawing.Size(216, 36)
        Me.TextBox1.TabIndex = 5
        Me.TextBox1.Text = "---"
        Me.TextBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label3
        '
        Me.Label3.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label3.Location = New System.Drawing.Point(8, 128)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(72, 23)
        Me.Label3.TabIndex = 4
        Me.Label3.Text = "Left (Ch2)"
        Me.Label3.TextAlign = System.Drawing.ContentAlignment.BottomLeft
        '
        'Label2
        '
        Me.Label2.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label2.Location = New System.Drawing.Point(8, 80)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(80, 23)
        Me.Label2.TabIndex = 3
        Me.Label2.Text = "Right (Ch1)"
        Me.Label2.TextAlign = System.Drawing.ContentAlignment.BottomLeft
        '
        'ComboBox1
        '
        Me.ComboBox1.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.ComboBox1.Items.AddRange(New Object() {"dBSPL(A)", "mV Max. Output Volt.", "mV WBCV"})
        Me.ComboBox1.Location = New System.Drawing.Point(144, 16)
        Me.ComboBox1.Name = "ComboBox1"
        Me.ComboBox1.Size = New System.Drawing.Size(152, 24)
        Me.ComboBox1.TabIndex = 2
        '
        'NumericUpDown1
        '
        Me.NumericUpDown1.DecimalPlaces = 1
        Me.NumericUpDown1.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.NumericUpDown1.Location = New System.Drawing.Point(80, 16)
        Me.NumericUpDown1.Maximum = New Decimal(New Integer() {200, 0, 0, 0})
        Me.NumericUpDown1.Name = "NumericUpDown1"
        Me.NumericUpDown1.Size = New System.Drawing.Size(56, 23)
        Me.NumericUpDown1.TabIndex = 1
        Me.NumericUpDown1.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
        Me.NumericUpDown1.Value = New Decimal(New Integer() {100, 0, 0, 0})
        '
        'Label1
        '
        Me.Label1.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.Location = New System.Drawing.Point(8, 16)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(40, 23)
        Me.Label1.TabIndex = 0
        Me.Label1.Text = "Limit"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'GroupBox3
        '
        Me.GroupBox3.Controls.Add(Me.TextBox10)
        Me.GroupBox3.Controls.Add(Me.Label11)
        Me.GroupBox3.Controls.Add(Me.Button15)
        Me.GroupBox3.Controls.Add(Me.Button14)
        Me.GroupBox3.Controls.Add(Me.Button13)
        Me.GroupBox3.Controls.Add(Me.CheckBox3)
        Me.GroupBox3.Controls.Add(Me.GroupBox4)
        Me.GroupBox3.Controls.Add(Me.TextBox5)
        Me.GroupBox3.Controls.Add(Me.Label5)
        Me.GroupBox3.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox3.Location = New System.Drawing.Point(352, 176)
        Me.GroupBox3.Name = "GroupBox3"
        Me.GroupBox3.Size = New System.Drawing.Size(312, 312)
        Me.GroupBox3.TabIndex = 29
        Me.GroupBox3.TabStop = False
        Me.GroupBox3.Text = "Report"
        '
        'TextBox10
        '
        Me.TextBox10.Location = New System.Drawing.Point(80, 56)
        Me.TextBox10.Name = "TextBox10"
        Me.TextBox10.Size = New System.Drawing.Size(216, 23)
        Me.TextBox10.TabIndex = 36
        Me.TextBox10.Text = ""
        '
        'Label11
        '
        Me.Label11.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label11.Location = New System.Drawing.Point(16, 56)
        Me.Label11.Name = "Label11"
        Me.Label11.Size = New System.Drawing.Size(64, 23)
        Me.Label11.TabIndex = 35
        Me.Label11.Text = "Comment"
        Me.Label11.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Button15
        '
        Me.Button15.Enabled = False
        Me.Button15.Location = New System.Drawing.Point(216, 280)
        Me.Button15.Name = "Button15"
        Me.Button15.Size = New System.Drawing.Size(80, 23)
        Me.Button15.TabIndex = 34
        Me.Button15.Text = "Print"
        '
        'Button14
        '
        Me.Button14.Enabled = False
        Me.Button14.Location = New System.Drawing.Point(112, 280)
        Me.Button14.Name = "Button14"
        Me.Button14.Size = New System.Drawing.Size(80, 23)
        Me.Button14.TabIndex = 33
        Me.Button14.Text = "Preview"
        '
        'Button13
        '
        Me.Button13.Location = New System.Drawing.Point(8, 280)
        Me.Button13.Name = "Button13"
        Me.Button13.Size = New System.Drawing.Size(80, 23)
        Me.Button13.TabIndex = 32
        Me.Button13.Text = "Page Setup"
        '
        'CheckBox3
        '
        Me.CheckBox3.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBox3.Location = New System.Drawing.Point(160, 248)
        Me.CheckBox3.Name = "CheckBox3"
        Me.CheckBox3.Size = New System.Drawing.Size(144, 24)
        Me.CheckBox3.TabIndex = 31
        Me.CheckBox3.Text = "Include Spectrum"
        '
        'GroupBox4
        '
        Me.GroupBox4.Controls.Add(Me.TextBox9)
        Me.GroupBox4.Controls.Add(Me.Label10)
        Me.GroupBox4.Controls.Add(Me.TextBox8)
        Me.GroupBox4.Controls.Add(Me.Label9)
        Me.GroupBox4.Controls.Add(Me.TextBox7)
        Me.GroupBox4.Controls.Add(Me.Label8)
        Me.GroupBox4.Controls.Add(Me.TextBox6)
        Me.GroupBox4.Controls.Add(Me.Label6)
        Me.GroupBox4.Location = New System.Drawing.Point(8, 88)
        Me.GroupBox4.Name = "GroupBox4"
        Me.GroupBox4.Size = New System.Drawing.Size(296, 152)
        Me.GroupBox4.TabIndex = 3
        Me.GroupBox4.TabStop = False
        Me.GroupBox4.Text = "Device Under Test"
        '
        'TextBox9
        '
        Me.TextBox9.Location = New System.Drawing.Point(72, 120)
        Me.TextBox9.Name = "TextBox9"
        Me.TextBox9.Size = New System.Drawing.Size(216, 23)
        Me.TextBox9.TabIndex = 10
        Me.TextBox9.Text = ""
        '
        'Label10
        '
        Me.Label10.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label10.Location = New System.Drawing.Point(8, 120)
        Me.Label10.Name = "Label10"
        Me.Label10.Size = New System.Drawing.Size(64, 23)
        Me.Label10.TabIndex = 9
        Me.Label10.Text = "Serial"
        Me.Label10.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'TextBox8
        '
        Me.TextBox8.Location = New System.Drawing.Point(72, 89)
        Me.TextBox8.Name = "TextBox8"
        Me.TextBox8.Size = New System.Drawing.Size(216, 23)
        Me.TextBox8.TabIndex = 8
        Me.TextBox8.Text = ""
        '
        'Label9
        '
        Me.Label9.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label9.Location = New System.Drawing.Point(8, 89)
        Me.Label9.Name = "Label9"
        Me.Label9.Size = New System.Drawing.Size(64, 23)
        Me.Label9.TabIndex = 7
        Me.Label9.Text = "Type"
        Me.Label9.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'TextBox7
        '
        Me.TextBox7.Location = New System.Drawing.Point(72, 56)
        Me.TextBox7.Name = "TextBox7"
        Me.TextBox7.Size = New System.Drawing.Size(216, 23)
        Me.TextBox7.TabIndex = 6
        Me.TextBox7.Text = ""
        '
        'Label8
        '
        Me.Label8.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label8.Location = New System.Drawing.Point(8, 56)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(64, 23)
        Me.Label8.TabIndex = 5
        Me.Label8.Text = "Manuf."
        Me.Label8.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'TextBox6
        '
        Me.TextBox6.Location = New System.Drawing.Point(72, 24)
        Me.TextBox6.Name = "TextBox6"
        Me.TextBox6.Size = New System.Drawing.Size(216, 23)
        Me.TextBox6.TabIndex = 4
        Me.TextBox6.Text = ""
        '
        'Label6
        '
        Me.Label6.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label6.Location = New System.Drawing.Point(8, 24)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(64, 23)
        Me.Label6.TabIndex = 3
        Me.Label6.Text = "Name"
        Me.Label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'TextBox5
        '
        Me.TextBox5.Location = New System.Drawing.Point(80, 24)
        Me.TextBox5.Name = "TextBox5"
        Me.TextBox5.Size = New System.Drawing.Size(216, 23)
        Me.TextBox5.TabIndex = 2
        Me.TextBox5.Text = ""
        '
        'Label5
        '
        Me.Label5.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label5.Location = New System.Drawing.Point(16, 24)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(64, 23)
        Me.Label5.TabIndex = 1
        Me.Label5.Text = "Operator"
        Me.Label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'Button12
        '
        Me.Button12.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Button12.Location = New System.Drawing.Point(576, 504)
        Me.Button12.Name = "Button12"
        Me.Button12.TabIndex = 30
        Me.Button12.Text = "Close"
        '
        'GroupBox5
        '
        Me.GroupBox5.Controls.Add(Me.Label12)
        Me.GroupBox5.Controls.Add(Me.NumericUpDown2)
        Me.GroupBox5.Controls.Add(Me.CheckBox4)
        Me.GroupBox5.Controls.Add(Me.CheckBox5)
        Me.GroupBox5.Controls.Add(Me.GroupBox6)
        Me.GroupBox5.Controls.Add(Me.GroupBox7)
        Me.GroupBox5.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.GroupBox5.Location = New System.Drawing.Point(8, 8)
        Me.GroupBox5.Name = "GroupBox5"
        Me.GroupBox5.Size = New System.Drawing.Size(336, 368)
        Me.GroupBox5.TabIndex = 31
        Me.GroupBox5.TabStop = False
        Me.GroupBox5.Text = "Calibration"
        '
        'Label12
        '
        Me.Label12.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label12.Location = New System.Drawing.Point(248, 32)
        Me.Label12.Name = "Label12"
        Me.Label12.Size = New System.Drawing.Size(52, 23)
        Me.Label12.TabIndex = 31
        Me.Label12.Text = "seconds"
        Me.Label12.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'NumericUpDown2
        '
        Me.NumericUpDown2.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.NumericUpDown2.Location = New System.Drawing.Point(192, 32)
        Me.NumericUpDown2.Maximum = New Decimal(New Integer() {200, 0, 0, 0})
        Me.NumericUpDown2.Name = "NumericUpDown2"
        Me.NumericUpDown2.Size = New System.Drawing.Size(56, 23)
        Me.NumericUpDown2.TabIndex = 30
        Me.NumericUpDown2.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
        Me.NumericUpDown2.Value = New Decimal(New Integer() {10, 0, 0, 0})
        '
        'CheckBox4
        '
        Me.CheckBox4.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBox4.Location = New System.Drawing.Point(88, 32)
        Me.CheckBox4.Name = "CheckBox4"
        Me.CheckBox4.Size = New System.Drawing.Size(112, 24)
        Me.CheckBox4.TabIndex = 29
        Me.CheckBox4.Text = "Delay start by"
        '
        'CheckBox5
        '
        Me.CheckBox5.Font = New System.Drawing.Font("Tahoma", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.CheckBox5.Location = New System.Drawing.Point(8, 32)
        Me.CheckBox5.Name = "CheckBox5"
        Me.CheckBox5.Size = New System.Drawing.Size(80, 24)
        Me.CheckBox5.TabIndex = 28
        Me.CheckBox5.Text = "Selective"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(7, 16)
        Me.ClientSize = New System.Drawing.Size(672, 533)
        Me.Controls.Add(Me.GroupBox5)
        Me.Controls.Add(Me.Button12)
        Me.Controls.Add(Me.GroupBox3)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.GroupBox1)
        Me.Font = New System.Drawing.Font("Verdana", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "Form1"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "1GA48 - Measurement according to EN 50332"
        Me.GroupBox7.ResumeLayout(False)
        Me.GroupBox6.ResumeLayout(False)
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox2.ResumeLayout(False)
        CType(Me.NumericUpDown1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox3.ResumeLayout(False)
        Me.GroupBox4.ResumeLayout(False)
        Me.GroupBox5.ResumeLayout(False)
        CType(Me.NumericUpDown2, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub Button12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button12.Click   '"Close" button
        Me.Close()
    End Sub

    Private Sub Delay(ByVal DelayTime As Long)                          'Delay of program execution in milliseconds
        Dim TimeInstance As Long
        TimeInstance = System.Environment.TickCount
        Do
            Application.DoEvents()
        Loop Until (System.Environment.TickCount - TimeInstance > DelayTime)
    End Sub

    Private Function InitiateUpx() As Boolean                                          'Make connection to UPV firmware
        Dim Result As Boolean = False
        Dim Counter As Integer = 0
        Dim Instring As String

        Try
            UPV.InitTCP("localhost")                                            ' connect UPV
            UPV.Timeout = 60001
            Do                                                                  'Read error queue until "0; No Error" shows up
                UPV.Write("SYST:ERR?")
                Instring = UPV.Read
                If Instring.StartsWith("0") Then
                    Debug.WriteLine(" succeeded")
                    Result = True
                End If
                Counter += 1
            Loop Until Result Or Counter > 10000                                'Stop when error queue is empty or too long
            Result = True
        Catch ex As Exception
            MessageBox.Show("Connection to UPV Firmware could not be established." & ControlChars.CrLf & "Check whether UPV firmware is running and try again!", "Connect UPV", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Me.Close()
        End Try
        Return Result
    End Function

    Private Sub CloseUpx()
        UPV.Close()                                                         ' disconnect UPV
    End Sub

    Private Function StringGet(ByVal FileNum As Integer) As String
        'Reads an integer value and a string with the length of the read integer value from a binary file
        Dim Len As Integer
        FileGet(FileNum, Len)
        Dim Instring As New String(" ", Len)
        If Len > 0 Then
            FileGet(FileNum, Instring)
        Else
            Instring = String.Empty
        End If
        Return Instring
    End Function

    Private Sub ClearErrorQueue()                                           'Discards error messages present in the error queue from other actions
        Dim ErrString As String
        Do
            UPV.Write("SYST:ERR?")
            ErrString = UPV.Read
        Loop Until ErrString.StartsWith("0")
    End Sub

    Private Sub StringPut(ByVal FileNum As Integer, ByVal Outstring As String)
        'Writes a string to a binary file, headed by its length as integer value
        Dim Len As Integer = Outstring.Length
        FilePut(FileNum, Len)
        FilePut(FileNum, Outstring)
    End Sub

    Private Sub UPVCommand(ByVal CommandString As String)                   'Sends command to UPV and checks error queue
        Dim ErrString As String

        UPV.Write(CommandString)                                            'Send command to UPV firmware
        Debug.Write("UPV Command = " & CommandString)
        UPV.Write("Syst:Err?")                                              'Query error queue
        Do
            ErrString = UPV.Read
        Loop Until ErrString <> String.Empty                                'workaround for occasional empty strings
        If Not ErrString.StartsWith("0") Then                               'Error occurred
            MessageBox.Show("UPV Error" & ControlChars.CrLf & ErrString, String.Empty, MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly)
            Application.Exit()                                              'Break program execution
        End If
        Debug.WriteLine("   Err = " & ErrString)
    End Sub

    Private Function UPVQuery(ByVal QueryString As String) As String        'Sends a query to UPV, reads response and checks error queue
        Dim AnswerString As String
        Dim ErrString As String

        UPV.Write(QueryString)                                              'Send query command to UPV firmware
        Debug.Write("UPV Query = " & QueryString)
        Do
            AnswerString = UPV.Read                                         'Read answer
            If AnswerString = String.Empty Then
                UPV.Write(QueryString)
            End If
        Loop Until AnswerString <> String.Empty                             'workaround for occasional empty strings
        Debug.Write("   Answer = " & AnswerString)
        UPV.Write("Syst:Err?")                                              'Query error queue
        Do
            ErrString = UPV.Read
            If ErrString = String.Empty Then
                Debug.WriteLine(" Empty answer string received")
            End If
        Loop Until ErrString <> String.Empty
        If Not ErrString.StartsWith("0") Then                               'Error occurred
            MessageBox.Show("UPV Error" & ControlChars.CrLf & ErrString, String.Empty, MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly)
            Application.Exit()                                              'Break program execution
        End If
        Debug.WriteLine("   Err = " & ErrString)
        Return AnswerString
    End Function

    Private Sub ReadCalibration(ByVal PathName As String, ByVal Channel As Byte)           'Reads calibration file 
        Dim Instring As New String(" ", 9)
        Dim CurveDateTime(1) As DateTime
        Dim InUsage As Byte

        Try
            Debug.WriteLine("Reading calibration file " & PathName)
            FileOpen(1, PathName, OpenMode.Binary, OpenAccess.Read)
            Debug.WriteLine("File 1 opened")
            FileGet(1, Instring)
            Debug.WriteLine("Instring = " & Instring)
            If Instring = "RS_UPV_CL" Then                                  'File valid?
                FileGet(1, InUsage)                                         'Reads usage type
                Debug.WriteLine("Usage = " & InUsage.ToString)
                With _CalibrationDevice(Channel)
                    .Usage = InUsage
                    FileGet(1, .CalValue)                                   'Read calibration value
                    Debug.WriteLine("CalValue = " & .CalValue.ToString)
                    .EqualizationFileName = String.Empty                    'No Equalization file for microphone calibration
                End With
            End If
            FileClose(1)
            Debug.WriteLine("File 1 closed")
        Catch ex As Exception
            Debug.WriteLine(ex.ToString)
            FileClose(1)
            Debug.WriteLine("File 1 closed")
        End Try
    End Sub

    Private Sub MicCalibration(ByVal Channel As Byte)                       'Input calibration
        'Dim SetupDateTime As DateTime
        Dim Outstring As String
        Dim Instring As String
        Dim CalSPL As Double
        Dim Time1 As Integer
        Dim Index1 As Integer
        Dim Index2 As Integer
        Dim MeasurementValue(9) As Double
        Dim Max As Double
        Dim Min As Double
        Dim Average As Double
        Dim IsOk As Boolean = False
        Dim Store As Boolean = False
        Const Accuracy As Double = 0.2
        Dim Measurebox As New Measuring
        Dim CalFrequency As Double
        Dim CalibrationFile As String
        Dim Usage As Byte = 0
        Dim Selective As Boolean

        Try
            With New ValueEntry
                .Text = "Calibration SPL in dBspl"
                .MaxValue = 150
                .MinValue = 0
                .Value = 97.1
                If .ShowDialog = DialogResult.OK Then                       'Input calibrator SPL
                    CalSPL = .Value
                End If
                .Close()
                .Dispose()
            End With
            Selective = CheckBox5.Checked
            If Selective Then
                With New ValueEntry
                    .Text = "Calibration Frequency [Hz]"
                    .MaxValue = 20000
                    .MinValue = 0
                    .Value = 1000
                    If .ShowDialog = DialogResult.OK Then                   'Input calibrator frequency
                        CalFrequency = .Value
                    End If
                    .Close()
                    .Dispose()
                End With
            End If
            MessageBox.Show("Connect microphone to Analyzer input " & Channel.ToString & "." & vbCrLf & "Insert microphone into calibrator and switch on calibrator.")
            If CheckBox4.Checked Then
                With New CountDown                                          'Delay start for specified number of seconds
                    .Count = NumericUpDown2.Value
                    .ShowDialog()
                    .Start()
                End With
            End If
            Measurebox.Show()                                               'Show "Measuring" window
            Delay(10)                                                       'Update display
            UPVCommand("*CLS")                                              'Clear status system
            UPVCommand("MMEMory:LOAD:STATe 'D:\UPV\EN50332\MicCal.SET';*WAI") 'Load specific setup
            ClearErrorQueue()
            Debug.WriteLine("Setup file loaded.")
            If Selective Then
                UPVCommand("SENSe:FUNCtion RMSS")                           'Measurement function "RMS Selective"
                UPVCommand("SENSe:BANDwidth:MODE PPCT3")                    '3% Bandwidth
                UPVCommand("SENSe:FUNCtion:APERture:MODE AUTo")             'measurement time "Auto"
                UPVCommand("SENSe:FREQuency:SELect FIX")                    'Fix frequency
                UPVCommand("SENSe:FREQuency " & CalFrequency.ToString & " HZ")  'Frequency value from input window
                UPVCommand("SENSe:NOTCh OFF")
                UPVCommand("SENSe:FILTer2 OFF")
                UPVCommand("SENSe:FUNCtion:SETTling:MODE OFF")
            End If
            Outstring = "INPut:CHANnel CH" & Channel.ToString               'Select analyzer channel
            UPVCommand(Outstring)
            Outstring = "SENS:DATA" & Channel.ToString & "?"                'SCPI Query for input 1/2
            Time1 = System.Environment.TickCount                            'Memorize start time for timeout
            Debug.WriteLine("Time1 = " & Time1.ToString)
            For Index1 = 0 To 9                                             'Evaluate at least 10 values
                Debug.WriteLine("Index1 = " & Index1.ToString)
                UPVCommand("INIT:CONT OFF;*WAI")                            'Start measurement
                Instring = UPVQuery(Outstring)                              'Query result
                Debug.WriteLine("Index1 = " & Index1 & " Value = " & Instring)
                MeasurementValue(Index1) = Val(Instring)
            Next
            Do
                Index1 += 1
                If Index1 > 9 Then Index1 -= 10
                UPVCommand("INIT:CONT OFF;*WAI")                            'Start measurement
                Instring = UPVQuery(Outstring)                              'Query result
                Debug.WriteLine("Index1 = " & Index1 & " Value = " & Instring)
                MeasurementValue(Index1) = Val(Instring)
                Max = -1000
                Min = 1000
                Average = 0
                For Index2 = 0 To 9                                         'Calculate max, min and average over 10 values
                    If MeasurementValue(Index2) > Max Then Max = MeasurementValue(Index2)
                    If MeasurementValue(Index2) < Min Then Min = MeasurementValue(Index2)
                    Average = Average + MeasurementValue(Index2)
                Next
                Average = Average / 10
                IsOk = (Average > -60) And (Average < 200) And ((Max - Min) < Accuracy)     'Conditions for valid result
            Loop Until (System.Environment.TickCount > Time1 + 10000) Or IsOk               'Make more measurements if result is not valid
            Measurebox.Hide()
            If IsOk Then                                                    'Calibration valid
                Select Case Channel
                    Case 1 : Button7.Enabled = True 'Enable "Start" button
                    Case 2 : CheckBox1.Enabled = True 'Enable "Binaural" Checkbox

                End Select
                Debug.WriteLine("Average = " & Average.ToString & "  CalSPL = " & CalSPL.ToString)
                With SaveFileDialog1                                        'Save calibration value to file
                    .Title = "Save microphone calibration as"
                    .FileName = "MicCal.icl"
                    .Filter = "Microphone calibration files (*.icl)|*.icl"
                    .InitialDirectory = "D:\UPV\EN50332"
                    If .ShowDialog = DialogResult.OK Then
                        If Channel = 1 Then
                            TextBox2.Text = .FileName                       'Show file name in text box
                        Else
                            TextBox3.Text = .FileName                       'Show file name in text box
                        End If
                        CalibrationFile = .FileName
                        _CalibrationDevice(Channel).CalValue = Average - CalSPL     'Ear sensitivity in dB(V/Pa)
                        FileOpen(4, CalibrationFile, OpenMode.Binary)
                        Outstring = "RS_UPV_CL"                                                     'file header
                        FilePut(4, Outstring)
                        FilePut(4, Usage)
                        FilePut(4, (Average - CalSPL))                      'Ear sensitivity in dB(V/Pa)
                        FileClose(4)
                        MessageBox.Show((1000 * Math.Pow(10, ((Average - CalSPL + 93.98) / 20))).ToString("0.00") & " mV/Pa")
                    End If
                End With
            Else
                If (Max - Min) > Accuracy Then
                    MessageBox.Show("Level instable. Please check connections and function of calibrator and re-try.")
                Else
                    MessageBox.Show("Level too small. Please check connections and function of calibrator and re-try.")
                End If
            End If
        Catch ex As Exception
            Debug.WriteLine(ex.ToString)
        End Try

    End Sub

    Private Sub LoadSettings()      'space for code to load settings from a file

    End Sub

    Private Sub LoadDefault()
        Dim Index As Integer
        Dim DefaultLimit As Double() = {100, 150, 75}

        For Index = 0 To 2
            Limit(Index) = DefaultLimit(Index)
        Next
        ComboBox1.SelectedIndex = 0
        ComboBox2.SelectedIndex = 0

    End Sub

    Private Sub SaveSettings()      'space for code to save settings to a file


    End Sub

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load     'This routine is called during start of the program
        Dim FoundFiles() As String
        Dim SingleFile As String
        Dim NewFile As String

        Me.Visible = False
        ResultValue(0) = 2.0E+32
        If Not Directory.Exists("D:\UPV\EN50332") Then                              'Working folder does not exist
            If Directory.Exists("C:\Program Files\Rohde&Schwarz\EN50332\Data") Then
                Directory.CreateDirectory("D:\UPV\EN50332")                         'Create working folder
                FoundFiles = Directory.GetFiles("C:\Program Files\Rohde&Schwarz\EN50332\Data")
                For Each SingleFile In FoundFiles
                    NewFile = "D:\UPV\EN50332" & SingleFile.Substring(SingleFile.LastIndexOf("\"c))
                    Debug.WriteLine("NewFile = " & NewFile)
                    File.Copy(SingleFile, NewFile)                                  'Copy files from program folder to working folder
                Next
            Else
                MessageBox.Show("Directory 'D:\UPV\EN50332' is not existing." & ControlChars.CrLf & "Please create this directory and copy the setup files" & ControlChars.CrLf & "of this application note to this directory!")
                Me.Close()
                Exit Sub
            End If
        End If
        If InitiateUpx() Then                                                           'Connect to UPV firmware
            UPV.Write("*GTL")                                                           'Send UPV window back to manual control
            ResultValue(0) = 1.0E-32                                                    'Invalid result
            ResultValue(1) = 1.0E-32
            If File.Exists("D:\UPV\EN50332\Settings.set") Then
                LoadSettings()
            Else
                LoadDefault()
            End If
            Me.Visible = True
        Else
            Me.Close()
            Exit Sub
        End If


    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click     'Start calibration of right ear
        MicCalibration(1)
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click     'Start calibration of left ear
        MicCalibration(2)
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click     'Read calibration value of right ear from file
        With OpenFileDialog1
            .Title = "Channel 1 mic calibration file"
            .Filter = "Microphone calibration files (*.icl)|*.icl"
            .InitialDirectory = "D:\UPV\EN50332"
            If .ShowDialog = DialogResult.OK Then
                TextBox2.Text = .FileName
                ReadCalibration(TextBox2.Text, 1)
                Button7.Enabled = True
            End If
        End With
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click     'Read calibration value of left ear from file
        With OpenFileDialog1
            .Title = "Channel 2 mic calibration file"
            .Filter = "Microphone calibration files (*.icl)|*.icl"
            .InitialDirectory = "D:\UPV\EN50332"
            If .ShowDialog = DialogResult.OK Then
                TextBox3.Text = .FileName
                ReadCalibration(TextBox3.Text, 2)
                CheckBox1.Enabled = True
            End If
        End With
    End Sub

    Private Sub ComboBox1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox1.SelectedIndexChanged
        If Not (PreviousIndex = -1) Then
            Limit(PreviousIndex) = NumericUpDown1.Value
        End If
        NumericUpDown1.Value = Limit(ComboBox1.SelectedIndex)                       'limit value for selected measurement
        PreviousIndex = ComboBox1.SelectedIndex                                     'Memorize current selection
    End Sub

    Private Sub Button13_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button13.Click   'Page Setup
        RPT.PageSetup()
    End Sub

    Private Sub Button14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button14.Click   'Print Preview
        Try
            If CheckBox3.Checked Then
                UPVCommand("SYSTem:DISPlay:SCPiupdate ON")
                UPVCommand("DISPlay:FFT:SHOW ON")
                UPVCommand("HCOPy:SOURce GRAP")                                     'Set source to active graphics
                UPVCommand("HCOPy:DESTination CLIP")                                'Set destination to clipboard
                UPVCommand("HCOPy:GSIZe '600x450'")                                 'Set size for DIN A4 with proper margins
                Me.WindowState = FormWindowState.Minimized                          'Minimize this window so that the UPV window gets the focus
                Delay(500)                                                          'Give UI time for updating
                UPVCommand("HCOP:IMM")                                              'Trigger hardcopy
                UPVCommand("SYSTem:DISPlay:SCPiupdate OFF")
                UPV.Write("*GTL")                                                   'Allow local control of the UPV
                Me.WindowState = FormWindowState.Normal                             'Restore this window
            End If
            RPT.PrintPreview()                                                      'Shows preview
        Catch ex As Exception
            Debug.WriteLine(ex.ToString)
            MessageBox.Show("Error in print preview")
        End Try
    End Sub

    Private Sub Button15_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button15.Click   'Print
        Try
            If CheckBox3.Checked Then
                UPVCommand("SYSTem:DISPlay:SCPiupdate ON")                          'Live update of the UPV window
                UPVCommand("DISPlay:FFT:SHOW ON")                                   'Open FFT Graph window
                UPVCommand("HCOPy:SOURce GRAP")                                     'Set source to active graphics
                UPVCommand("HCOPy:DESTination CLIP")                                'Set destination to clipboard
                UPVCommand("HCOPy:GSIZe '600x450'")                                 'Set size for DIN A4 with proper margins
                Me.WindowState = FormWindowState.Minimized                          'Minimize this window so that the UPV window gets the focus
                Delay(500)                                                          'Give UI time for updating
                UPVCommand("HCOP:IMM")                                              'Trigger hardcopy
                UPVCommand("SYSTem:DISPlay:SCPiupdate OFF")
                UPV.Write("*GTL")                                                   'Allow local control of the UPV
                Me.WindowState = FormWindowState.Normal                             'Restore this window
            End If
            RPT.Print()
        Catch ex As Exception
            Debug.WriteLine(ex.ToString)
            MessageBox.Show("Error in print")
        End Try
    End Sub

    Private Sub RPT_PrintPage() Handles RPT.PrintPage                               'Event handler (callback) for filling the print page
        Debug.WriteLine("RPT.PrintPage")
        Dim data As IDataObject = Clipboard.GetDataObject()
        Dim ColumnWidth As Integer = 40
        Dim RowHeight As Integer = 20
        Dim XPos(5) As Integer
        Dim YPos(2) As Integer
        Dim Index As Integer
        Dim ColumnHeader() As String
        Dim RowHeader() As String
        Dim ColumnCount As Byte = 0
        Dim RowCount As Byte = 0
        Dim Verdict As Boolean

        Try
            With RPT
                .AppendHeadline("R&S Test Report")
                .AppendSubHeadline(Description(MeasType))
                .HorizontalLine()
                .AppendSubHeadline("General")
                .AppendValueLine("Date:", DateTime.Now.ToString)
                If Not TextBox5.Text = String.Empty Then
                    .AppendValueLine("Operator:", TextBox5.Text)
                End If
                If Not (TextBox10.Text = String.Empty) Then      'Comment
                    .AppendValueLine("Comment:", TextBox10.Text)
                End If
                .HorizontalLine()
                '**************** DUT information **********************************************
                If Not ((TextBox6.Text = String.Empty) And (TextBox7.Text = String.Empty) And (TextBox8.Text = String.Empty) And (TextBox9.Text = String.Empty)) Then
                    .AppendSubHeadline("Test Object")
                    If Not TextBox6.Text = String.Empty Then
                        .AppendValueLine("Name:", TextBox6.Text)
                    End If
                    If Not TextBox7.Text = String.Empty Then
                        .AppendValueLine("Manufacturer:", TextBox7.Text)
                    End If
                    If Not TextBox8.Text = String.Empty Then
                        .AppendValueLine("Type:", TextBox8.Text)
                    End If
                    If Not TextBox9.Text = String.Empty Then
                        .AppendValueLine("Serial No.:", TextBox9.Text)
                    End If
                    .HorizontalLine()
                End If

                '**************** Set up table with result values *****************************
                If Binaural Then RowCount = 2 Else RowCount = 1
                If ResultValue(0) < 2.0E+32 Then
                    .AppendSubHeadline("Results")
                    Dim ResultValues As New UPVReport.ReportTable(3, RowCount, True, True)
                    With ResultValues
                        ReDim ColumnHeader(3)
                        ColumnHeader(1) = ValueName(MeasType)
                        If MeasType < 4 Then
                            ColumnHeader(2) = " Upper Limit"
                        Else
                            ColumnHeader(2) = "Lower Limit"
                        End If
                        ColumnHeader(3) = "Verdict"
                        .ColumnHeader = ColumnHeader

                        ReDim RowHeader(RowCount - 1)
                        RowHeader(0) = "Right (Ch1)"
                        If Binaural Then
                            RowHeader(1) = "Left (Ch2)"
                        End If
                        .RowHeader = RowHeader

                        For Index = 1 To RowCount
                            .Cell(Index, 1) = ResultValue(Index - 1).ToString("0.00 ") & Unit(MeasType)
                            .Cell(Index, 2) = NumericUpDown1.Value.ToString("0.00 ") & Unit(MeasType)
                            If MeasType < 4 Then
                                Verdict = (ResultValue(Index - 1) <= NumericUpDown1.Value)
                            Else
                                Verdict = (ResultValue(Index - 1) >= NumericUpDown1.Value)
                            End If
                            If Verdict Then
                                .Cell(Index, 3) = "Pass"
                            Else
                                .Cell(Index, 3) = "Fail"
                            End If
                        Next
                    End With
                    .AppendTable(ResultValues, False)
                End If

                If CheckBox3.Checked And (data.GetDataPresent(DataFormats.Bitmap)) Then 'Include Graph
                    .HorizontalLine()
                    .AppendImage(data.GetData(DataFormats.Bitmap))
                End If
            End With
        Catch ex As Exception
            Debug.WriteLine(ex.ToString)
            MessageBox.Show("Error in print preparation")
        End Try
    End Sub

    Private Sub ComboBox2_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox2.SelectedIndexChanged   'Selection of measurement type
        Label13.Text = ValueName(ComboBox2.SelectedIndex)       'Heading for result value
        Select Case ComboBox2.SelectedIndex
            Case 0
                ComboBox1.SelectedIndex = 0
                Button7.Enabled = (TextBox2.Text <> "select ...")
                CheckBox1.Enabled = (TextBox3.Text <> "select ...")
            Case 1
                ComboBox1.SelectedIndex = 0
                Button7.Enabled = (TextBox2.Text <> "select ...")
                CheckBox1.Enabled = (TextBox3.Text <> "select ...")
            Case 2
                ComboBox1.SelectedIndex = 1
                Button7.Enabled = True       'No calibration value required
                CheckBox1.Enabled = True
            Case 3
                ComboBox1.SelectedIndex = 1
                Button7.Enabled = True        'No calibration value required
                CheckBox1.Enabled = True
            Case 4
                ComboBox1.SelectedIndex = 2
                Button7.Enabled = (TextBox2.Text <> "select ...")
                CheckBox1.Enabled = (TextBox3.Text <> "select ...")
        End Select
    End Sub

    Private Sub MeasureCombination(ByVal FM As Boolean, ByVal TwoChannel As Boolean)    'Measures player/tuner with headset
        Dim Instring As String
        Dim Measurebox As New Measuring

        TextBox1.Text = "---"
        TextBox1.ForeColor = SystemColors.ControlLightLight
        TextBox4.Text = "---"
        TextBox4.ForeColor = SystemColors.ControlLightLight
        Measurebox.Show()                                                               'Display the "Measuring" window
        Delay(10)
        MeasType = 0
        UPVCommand("MMEMory:LOAD:STATe 'D:/UPV/EN50332/EN50332.set'")                   'Load setup
        UPVCommand("SENSe:REFerence " & _CalibrationDevice(1).CalValue.ToString("0.000") & " DBV")  'Ear calibration value
        If TwoChannel Then
            UPVCommand("INPut:CHANnel CH2Is1")                                          'Two-channel measurement
            UPVCommand("DISPlay:FFT:B:YSOurce FFTL2")                                   'Switch on second FFT trace
            UPVCommand("SENSe:REFerence2 " & _CalibrationDevice(2).CalValue.ToString("0.000") & " DBV") 'Second ear calibration value
        Else
            UPVCommand("INPut:CHANnel CH1")                                             'One-channel measurement
            UPVCommand("DISPlay:FFT:B:YSOurce OFF")                                     'Switch off second FFT trace
        End If
        If FM Then
            UPVCommand("OUTPut:CHANnel CH2Is1")                                         'Switch on generator output
            UPVCommand("SOURce:VOLTage:TOTal 6.44 DBV")                                    'Full-scale generator output voltage
            MeasType = 1                                                                'Memorize measurement type for the report
        End If
        UPVCommand("INIT:CONT OFF;*WAI")                                                'Start measurement
        Instring = UPVQuery("Sens:Data?")                                               'Query result
        ResultValue(0) = Val(Instring)
        If ResultValue(0) > NumericUpDown1.Value Then                                   'Limit check
            TextBox1.ForeColor = Color.Red
        Else
            TextBox1.ForeColor = Color.LightGreen
        End If
        TextBox1.Text = ResultValue(0).ToString("0.00") & " " & Unit(MeasType)          'Display result
        If TwoChannel Then
            Instring = UPVQuery("Sens:Data2?")
            ResultValue(1) = Val(Instring)
            If ResultValue(1) > NumericUpDown1.Value Then                               'Limit check
                TextBox4.ForeColor = Color.Red
            Else
                TextBox4.ForeColor = Color.LightGreen
            End If
            TextBox4.Text = ResultValue(1).ToString("0.00") & " " & Unit(MeasType)      'Display result
        End If
        UPV.Write("*GTL")
        Button14.Enabled = True                                                         'Enable report
        Button15.Enabled = True
        Measurebox.Close()
        Measurebox.Dispose()
    End Sub

    Private Sub MeasureDevice(ByVal FM As Boolean, ByVal TwoChannel As Boolean)         'Electric measurement of device only
        Dim Instring As String
        Dim Measurebox As New Measuring


        TextBox1.Text = "---"
        TextBox1.ForeColor = SystemColors.ControlLightLight
        TextBox4.Text = "---"
        TextBox4.ForeColor = SystemColors.ControlLightLight
        Measurebox.Show()                                                               'Display the "Measuring" window
        Delay(10)
        MeasType = 2
        UPVCommand("MMEMory:LOAD:STATe 'D:/UPV/EN50332/EN50332_device.set'")            'Load setup
        If TwoChannel Then
            UPVCommand("INPut:CHANnel CH2Is1")                                          'Two-channel measurement
            UPVCommand("DISPlay:FFT:B:YSOurce FFTL2")                                   'Switch on second FFT trace
        Else
            UPVCommand("INPut:CHANnel CH1")                                             'One-channel measurement
            UPVCommand("DISPlay:FFT:B:YSOurce OFF")                                     'Switch off second FFT trace
        End If
        If FM Then
            UPVCommand("OUTPut:CHANnel CH2Is1")                                         'Switch on generator output
            UPVCommand("SOURce:VOLTage:TOTal 6.44 DBV")                                    'Full-scale generator output voltage
            MeasType = 3                                                                'Memorize measurement type for the report
        End If
        UPVCommand("INIT:CONT OFF;*WAI")                                                'Start measurement
        Instring = UPVQuery("Sens:Data?")                                               'Query result
        ResultValue(0) = 1000 * Val(Instring)
        If ResultValue(0) > NumericUpDown1.Value Then                                   'Limit check
            TextBox1.ForeColor = Color.Red
        Else
            TextBox1.ForeColor = Color.LightGreen
        End If
        TextBox1.Text = ResultValue(0).ToString("0.00") & " " & Unit(MeasType)          'Display result
        If TwoChannel Then
            Instring = UPVQuery("Sens:Data2?")
            ResultValue(1) = 1000 * Val(Instring)
            If ResultValue(1) > NumericUpDown1.Value Then                               'Limit check
                TextBox4.ForeColor = Color.Red
            Else
                TextBox4.ForeColor = Color.LightGreen
            End If
            TextBox4.Text = ResultValue(1).ToString("0.00") & " " & Unit(MeasType)      'Display result
        End If
        UPV.Write("*GTL")
        Button14.Enabled = True                                                         'Enable report
        Button15.Enabled = True
        Measurebox.Close()
        Measurebox.Dispose()
    End Sub

    Private Sub MeasureHeadPhones(ByVal TwoChannel As Boolean)                          'WBCV of Headphones
        Dim Instring As String
        Dim Measurebox As New Measuring
        Dim GenLevel As Double = -12

        TextBox1.Text = "---"
        TextBox1.ForeColor = SystemColors.ControlLightLight
        TextBox4.Text = "---"
        TextBox4.ForeColor = SystemColors.ControlLightLight
        Measurebox.Show()                                                               'Display the "Measuring" window
        Delay(10)
        MeasType = 4                                                                    'Memorize measurement type for the report
        UPVCommand("MMEMory:LOAD:STATe 'D:/UPV/EN50332/EN50332_headphones.set'")        'Load setup    
        UPVCommand("SENSe:REFerence " & _CalibrationDevice(1).CalValue.ToString("0.000") & " DBV")  'Ear calibration value
        UPVCommand("SOURce:VOLTage:TOTal " & GenLevel.ToString & " DBV")                'Set initial generator level
        UPVCommand("INIT:CONT OFF;*WAI")                                                'Start measurement
        Instring = UPVQuery("Sens:Data?")                                               'Query result
        GenLevel += 94 - Val(Instring)                                                  'Corrected generator output level for 94 dBSPL
        If GenLevel < 0 Then                                                            'Avoid excessive output level
            UPVCommand("SOURce:VOLTage:TOTal " & GenLevel.ToString & " DBV")            'Set corrected generator level
            UPVCommand("INIT:CONT OFF;*WAI")                                            'Start second measurement
            Instring = UPVQuery("Sens:Data?")                                           'Query result
            If Math.Abs(Val(Instring) - 94) > 0.2 Then                                  'Is result precise enough?
                GenLevel += 94 - Val(Instring)                                          'Second correction
                If GenLevel < 0 Then                                                    'Avoid excessive output level
                    UPVCommand("SOURce:VOLTage:TOTal " & GenLevel.ToString & " DBV")    'Set corrected generator level
                    UPVCommand("INIT:CONT OFF;*WAI")                                    'Start 3rd measurement
                    Instring = UPVQuery("Sens:Data?")                                   'Query result
                Else
                    MessageBox.Show("Characteristic voltage cannot be adjusted." & ControlChars.CrLf & "Check signal path and try again!")
                    UPV.Write("*GTL")
                    Measurebox.Close()
                    Measurebox.Dispose()
                    Exit Sub
                End If
            End If
            If Math.Abs(Val(Instring) - 94) < 0.2 Then                                  'SPL is close enough to the target
                UPVCommand("DISPlay:FFT:A:UPDate HOLD")                                 'Keep spectrum of sound pressure
                UPVCommand("SENSe:FILTer OFF")                                          'No filter for electric measurement
                UPVCommand("SENSe:VOLTage:EQUalize OFF")                                'No equalizer for electric measurement
                UPVCommand("INIT:CONT OFF;*WAI")                                        'Start measurement of generator voltage
                Instring = UPVQuery("Sens:Data2?")                                      'Query result
                ResultValue(0) = 1000 * Val(Instring)
                If ResultValue(0) < NumericUpDown1.Value Then                           'Limit check
                    TextBox1.ForeColor = Color.Red
                Else
                    TextBox1.ForeColor = Color.LightGreen
                End If
                TextBox1.Text = ResultValue(0).ToString("0.00") & " " & Unit(MeasType)  'Display result
                Delay(10)                                                               'Update UI
            Else
                MessageBox.Show("Characteristic voltage cannot be adjusted." & ControlChars.CrLf & "Check signal path and try again!")
                UPV.Write("*GTL")
                Measurebox.Close()
                Measurebox.Dispose()
                Exit Sub
            End If
        Else
            MessageBox.Show("Characteristic voltage cannot be adjusted." & ControlChars.CrLf & "Check signal path and try again!")
            UPV.Write("*GTL")
            Measurebox.Close()
            Measurebox.Dispose()
            Exit Sub
        End If
        If TwoChannel Then                                                              'Measurement of second channel
            GenLevel = -12
            UPVCommand("SENSe:REFerence2 " & _CalibrationDevice(2).CalValue.ToString("0.000") & " DBV")  'Ear calibration value
            UPVCommand("SOURce:VOLTage:TOTal " & GenLevel.ToString & " DBV")            'Set initial generator level
            UPVCommand("SENSe:FILTer AWE")                                              'A weighting
            UPVCommand("SENSe:VOLTage:EQUalize ON")                                     'Freefield equalization
            UPVCommand("INPut:TYPE GEN2")                                               'Generator measurement
            UPVCommand("SENSe:UNIT V")
            UPVCommand("INPut2:TYPE BALanced")                                          'SPL measurement
            UPVCommand("SENSe:UNIT2 DBR")
            UPVCommand("INIT:CONT OFF;*WAI")                                            'Start first measurement
            Instring = UPVQuery("Sens:Data2?")                                          'Query result
            GenLevel += 94 - Val(Instring)                                              'Corrected generator output level for 94 dBSPL
            If GenLevel < 0 Then                                                        'Avoid excessive output level
                UPVCommand("SOURce:VOLTage:TOTal " & GenLevel.ToString & " DBV")        'Set corrected generator level
                UPVCommand("INIT:CONT OFF;*WAI")                                        'Start second measurement
                Instring = UPVQuery("Sens:Data2?")                                      'Query result
                If Math.Abs(Val(Instring) - 94) > 0.2 Then                              'Is result precise enough?
                    GenLevel += 94 - Val(Instring)                                      'Second correction
                    If GenLevel < 0 Then                                                'Avoid excessive output level
                        UPVCommand("SOURce:VOLTage:TOTal " & GenLevel.ToString & " DBV") 'Set corrected generator level
                        UPVCommand("INIT:CONT OFF;*WAI")                                'Start second measurement
                        Instring = UPVQuery("Sens:Data2?")                              'Query result
                    Else
                        MessageBox.Show("Characteristic voltage cannot be adjusted." & ControlChars.CrLf & "Check signal path and try again!")
                        UPV.Write("*GTL")
                        Measurebox.Close()
                        Measurebox.Dispose()
                        Exit Sub
                    End If
                End If
                If Math.Abs(Val(Instring) - 94) < 0.2 Then                              'SPL is close enough to the target
                    UPVCommand("DISPlay:FFT:B:UPDate HOLD")                             'Keep spectrum of sound pressure
                    UPVCommand("SENSe:FILTer OFF")                                      'No filter for electric measurement
                    UPVCommand("SENSe:VOLTage:EQUalize OFF")                            'No equalizer for electric measurement
                    UPVCommand("INIT:CONT OFF;*WAI")                                    'Start measurement of generator voltage
                    Instring = UPVQuery("Sens:Data?")                                   'Query result
                    ResultValue(1) = 1000 * Val(Instring)
                    If ResultValue(1) < NumericUpDown1.Value Then                       'Limit check
                        TextBox4.ForeColor = Color.Red
                    Else
                        TextBox4.ForeColor = Color.LightGreen
                    End If
                    TextBox4.Text = ResultValue(1).ToString("0.00") & " " & Unit(MeasType)
                Else
                    MessageBox.Show("Characteristic voltage cannot be adjusted." & ControlChars.CrLf & "Check signal path and try again!")
                    UPV.Write("*GTL")
                    Measurebox.Close()
                    Measurebox.Dispose()
                    Exit Sub
                End If
            Else
                MessageBox.Show("Characteristic voltage cannot be adjusted." & ControlChars.CrLf & "Check signal path and try again!")
                UPV.Write("*GTL")
                Measurebox.Close()
                Measurebox.Dispose()
                Exit Sub
            End If
        Else
            UPVCommand("DISPlay:FFT:B:YSOurce OFF")     'Switch off second spectrum trace
        End If
        UPV.Write("*GTL")
        Button14.Enabled = True                                                         'Enable report
        Button15.Enabled = True
        Measurebox.Close()
        Measurebox.Dispose()

    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click 'Start the measurement
        Binaural = CheckBox1.Checked
        Select Case ComboBox2.SelectedIndex
            Case 0 : MeasureCombination(False, Binaural)
            Case 1 : MeasureCombination(True, Binaural)
            Case 2 : MeasureDevice(False, Binaural)
            Case 3 : MeasureDevice(True, Binaural)
            Case 4 : MeasureHeadPhones(Binaural)
        End Select
    End Sub

    Private Sub Button16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button16.Click
        Dim FileName As String = "D:\UPV\EN50332\Set" & (ComboBox2.SelectedIndex + 1).ToString("0")     'measurement type
        Dim InString As String = String.Empty
        If CheckBox1.Checked Then
            FileName = FileName & "b"       'binaural
        End If
        FileName = FileName & ".txt"
        If File.Exists(FileName) Then
            FileOpen(1, FileName, OpenMode.Input)
            Do While Not EOF(1)                 'Read lines as long as the file has text
                InString &= LineInput(1) & ControlChars.CrLf
            Loop
            MessageBox.Show(InString)           'Show the text in a message box
            FileClose()
        Else
            MessageBox.Show("File not found.", "Setup?", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End If
    End Sub

    Private Sub CheckBox1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox1.CheckedChanged
        If Not CheckBox1.Checked Then
            TextBox4.Text = "---"
            TextBox4.ForeColor = SystemColors.ControlLightLight
        End If
    End Sub
End Class
